#version 120
#extension GL_EXT_gpu_shader4 : enable

attribute vec3 p0; 
attribute vec3 p1; 
attribute vec2 texcoord; 
attribute vec2 texcoord2;  

uniform mat4 viewproj; 
uniform mat4 view;
uniform mat4 proj;
uniform mat4 world;
uniform vec3 eyePos; 
uniform float grow; //levels*time
uniform float linesize = 0.5f;

uniform float max_radius; 
uniform float t; 

uniform float tracks[32];
varying vec2 tc; 
varying vec3 color; 
varying float fogCoef;
varying float a1;
varying float la; 
varying float dofCoef;
//random E[-1, 1]
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float farPlane = 2000.0;
float nearPlane = .0;
float exponent = 2.1500;
float focalPoint = .0252058111280133517510000000510; 



float fogFar = 2500.0;

float lineWidth = 1.75;
void main()
{

	vec4 vp0 = view*vec4(p0, 1.0);
	vec4 vp1 = view*vec4(p1, 1.0);
	vec4 mid = mix(vp1,vp0, texcoord.y);
	vec3 mid2 = mix(p1,p0, texcoord.y);
	vec4 dp0 = proj*vp0;
	vec4 dp1 = proj*vp1;
	vec2 dir = normalize(dp1.xy-dp0.xy);
	dir.y = -dir.y;
	vec4 npos = mid;
	vec3 add = mix(-vec3(dir.yx, 0), vec3(dir.yx, 0), texcoord.x);
	gl_Position = proj*npos;//npos;
	gl_Position += lineWidth*vec4(add, 0.0);

	tc = texcoord.xy;
	fogFar = tracks[28];
	float dist = clamp(1.0-length(mid2.xyz-eyePos)/fogFar, 0.0, 1.0);
	fogCoef = dist*dist;//*(1.0-texcoord.y);
	//fogCoef *= tracks[28];

	a1 = tracks[27];
	la = 1.0-clamp(length(p1-p0)/(0.95*max_radius), 0.0, 1.0);

	vec4 viewpos = npos;//view*npos;
	dist = clamp(1.0-length(viewpos.xyz-eyePos)/fogFar, 0.0, 1.0);
	//float pz = ((-viewpos.z)-nearPlane)/(farPlane-nearPlane); 
	float pz = ((-viewpos.z)-nearPlane)/(fogFar-nearPlane); 
	dofCoef = 1.0-clamp(pow(abs(pz-focalPoint)*40.0, exponent), 0.0, 1.0);
}

//FRAGMENT
#version 120
varying vec2 tc;
varying vec3 color; 
varying float fogCoef;
varying float a1; 
varying float la;
varying float dofCoef;
uniform sampler2D Texture0;
uniform sampler2D Texture1;
uniform float alpha_mul=1.0; 

void main() {

	vec4 p = texture2D(Texture0, tc.yx*.5+.25);
	vec4 p2 = texture2D(Texture1, tc.yx);
	vec4 p1 = texture2D(Texture0, tc.yx*vec2(1.0, 1.8)-vec2(0., .4));
	p = texture2D(Texture0, tc.yx);
	gl_FragColor.rgb = p.rgb;

	gl_FragColor = vec4(la);
	gl_FragColor *= vec4(fogCoef);

	gl_FragColor *= vec4(p2.r*p2.r);
	gl_FragColor = vec4(fogCoef);

	gl_FragColor = vec4(dofCoef);

	vec4 final = mix(p2*.5, p1,  dofCoef*dofCoef);
	gl_FragColor = vec4(final.r);
	gl_FragColor *= vec4(.6+.5*la);
	gl_FragColor *= vec4(a1*fogCoef);


}

